#include "TRandom.h"
#include <iostream.h>
#include <fstream.h>

Double_t beta = 1;

void photonMap3D(TH3D *pads, Double_t dx, Int_t nx, Double_t dlam, 
			Int_t nlam, Double_t lam0, Double_t xstart,
			Double_t ystart, Double_t phi, Double_t alpha)

// Fills a histogram pads with x, y, and t information. The photon times
// and positions are obtained by numerically integrating over a path starting 
// at (xstart, ystart) and with angle phi to the normal and alpha to the
// positive x-axis. All distances in um and times in picoseconds.

{
	nx = TMath::Nint(nx / cos(phi)); // Longer path because of angle
	
	Double_t c = 300;
	Double_t lam, prob, t, x, y, xf, yf, psi, sinTheta, cosTheta, dist;
	Double_t sigma = 25;
	Double_t cutOff = 5000;
	
	for(int i=0; i<nx; i++){
		for(int j=0; j<nlam; j++){
			lam = lam0 + j*dlam;
			prob = d2N(lam) * QE(lam) * dx * dlam;
			if(gRandom->Rndm() < prob){
				psi = gRandom->Rndm()*3.14159;
				cosTheta = 1/(beta*n0(lam));
				sinTheta = sqrt(1-cosTheta**2);

				x = i*dx*sin(phi) + ((nx-i)*dx*cos(phi)*(
					(cosTheta*sin(phi)+sinTheta*cos(psi)*cos(phi))/
					(cosTheta*cos(phi)-sinTheta*cos(psi)*sin(phi))));

				y = ((nx-i)*dx*cos(phi)*(
					(sinTheta*sin(psi))/
					(cosTheta*cos(phi)-sinTheta*cos(psi)*sin(phi))));

				dist = sqrt((x-i*dx*sin(phi))**2+y**2+((nx-i)*dx*cos(phi))**2);

				t = dist*n0(lam)/c-((nx-i)*dx*cos(phi)/(beta*c));

				if(gRandom->Rndm() < .5) y=-y;

				xf = x*cos(alpha) + y*sin(alpha) + xstart;
				yf = -x*sin(alpha) + y*cos(alpha) + ystart;
				if(gRandom->Rndm() < trans(lam,dist)){
					if(t>0 || psi < 1.570795){
						t += gRandom->Gaus(0,sigma);
						if(t <= cutOff){
							pads->Fill(xf,yf,t);
						}
					}
				}
			}
		}
	}

	return;
}

Double_t d2N(Double_t lam)
{
	return 2*3.14159*0.0072974*(1 - 1/(beta * n0(lam))**2)/lam**2;
}
