//#include "TRandom.h"
#include <iostream.h>
#include <fstream.h>

void pads2spice(TH3D* map, char filename[], Double_t gain)
{
	Double_t e = -1.602e-19; // C
	Double_t time = 1e+12; // ps/s
	
	Int_t xwidth = map->GetNbinsX();
	Int_t ywidth = map->GetNbinsY();
	Int_t zwidth = map->GetNbinsZ();

	ofstream out;
	out.open(filename);

	Int_t n = 1;

	for(Int_t x=0; x<xwidth; x++){
		for(Int_t y=0; y<ywidth; y++){
			TH1D* projection;
			projection = map->ProjectionZ("Pulse",x,x,y,y);
			Double_t width = (Double_t) projection->GetBinWidth(1);
			projection->Scale((time*e*gain/width));

			out << "I" << n << " 0 " << n << " PWL (";
			
			out << "0 0 ";
			for(Int_t z=1; z<zwidth-1; z++){
				Double_t proj1 = (Double_t) projection->GetBinContent(z-1);
				Double_t proj2 = (Double_t) projection->GetBinContent(z);
				Double_t proj3 = (Double_t) projection->GetBinContent(z+1);
				if(proj1 != proj2 || proj2 != proj3)){
					Double_t current = (Double_t) projection->GetBinContent(z);
					Double_t t = z * width;
					out << t << "p " << current << " ";
				}
			}
			out << zwidth << "p 0 3n 0)" << endl;
			n++;
		}
	}

	out.close();
	return;
}
