#ifndef _RIOSTREAM
#define _RIOSTREAM
#include "Riostream.h"
#endif

Double_t n0(Double_t lam) // lam in micrometers
// Sellmeier fit for index of refraction in fused silica
// Returns the index of refraction of the radiator at wavelength lam
{
	return sqrt(1+(0.68374049400 * lam**2)/(lam**2-0.00460352869)
                     +(0.42032361300 * lam**2)/(lam**2-0.01339688560)
                     +(0.58502748000 * lam**2)/(lam**2-64.4932732000));
}

// Variables to store transmittance data
const Int_t nlam_tr = 13;
Double_t lambda_tr[nlam_tr], trans[nlam_tr];	

void fusedSilica()
// Loads transmittance data (per 10mm) from file
{
	ifstream in;
	in.open("transSilica.dat");
	Double_t lam, tr;
	Int_t i;
	for (i=0; i<nlam_tr; i++){
		in >> lam >> tr;
		lambda_tr[i] = lam / 1000;
		trans[i] = tr / 100;
		}
	in.close();
}
		
Double_t trans(Double_t lam, Double_t dist) // lam, dist in micrometers
// Interpolates to determine percent transmittance over distance dist at wavelength lam
{
	if (lambda_tr[0] > lam)
		return 0;
	if (lambda_tr[nlam_tr-1] < lam)
		return (trans[nlam_tr-1])**(dist/10000);
	
	Int_t i = 1;
	while(lambda_tr[i]<lam)
		i += 1;
	return ((trans[i-1] + (trans[i] - trans[i-1])/(lambda_tr[i] - lambda_tr[i-1]) 
			* (lam - lambda_tr[i-1])))**(dist/10000);
}
