#ifndef _RIOSTREAM
#define _RIOSTREAM
#include "Riostream.h"
#endif

const Int_t nlam58 = 45;
Double_t lambda58[nlam58], qe58[nlam58];

void QE58()
{
	ifstream in;
	in.open("R3809U-58.dat");
	Double_t lam, qe;
	Int_t i;
	for (i=0; i<nlam58; i++){
		in >> lam >> qe;
		lambda58[i] = lam / 1000; // Put in um
		qe58[i] = qe / 100; // Get rid of percent sign
	}
	in.close();
}
		
Double_t QE(Double_t lam)
{
	if (lambda58[0] > lam || lambda58[nlam58 - 1] < lam)
		return 0;
	
	Int_t i = 0;
	while(lambda58[i]<lam)
		i += 1;
	return (qe58[i-1] + (qe58[i] - qe58[i-1])/(lambda58[i] - lambda58[i-1]) 
			* (lam - lambda58[i-1]));
}
